*** for all banks
*import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Bailout_2016/analystv2.csv", encoding(ISO-8859-1)clear
import delimited "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Bailout_2016\analystv2.csv", clear 


drop if actual == . 

gen date_predict = date(fpedats, "MDY")
gen date_announce=date(anndats_act, "MDY")

by cusip date_predict, sort: egen mean_predict=mean(value)
by cusip date_predict, sort: gen actual_deviation = (actual-mean_predict)/(actual+mean_predict)
by cusip date_predict, sort: egen std_dev = sd(value)


by cusip date_predict, sort: gen output_indicator = _n 
keep if output_indicator == 1


gen year = year(date_predict)
gen crisis = . 
replace crisis = 0 if (year >= 2002 & year <= 2007)
replace crisis = 1 if (year>=2010 & year <= 2015) 

su actual_deviation if crisis == 0 
su actual_deviation if crisis == 1 

reg actual_deviation crisis 
ttest actual_deviation, by(crisis)
*** dev from EPS

gen actual_deviation_abs=abs(actual_deviation)
ttest actual_deviation_abs, by(crisis)
*** dev from EPS (abs value)

**ttest std_dev, by (crisis)

rename date_announce date 

merge 1:1 cusip date using "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Autocorrelation\Data\price.dta"

drop if _merge != 3

gen scale_difference = (actual-mean_predict)/prc
ttest scale_difference, by(crisis)
*** deviation from pe ratio

gen scale_difference_abs = abs(scale_difference)
ttest scale_difference_abs, by(crisis)
*** absolute value deviation from pe ratio 
